



<html>
<head>
  <title>javabog.dk -  - Interfaces - gr&aelig;nseflader til objekter</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel11.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel13.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">12 <a name='afsn12'></a>Interfaces -
gr&aelig;nseflader til objekter</H1>
<P CLASS="kapiteloversigt-western">Indhold:</P>
<UL>
  <LI><P CLASS="kapiteloversigt-western">Forst&aring; og definere
  interfaces</P>
  <LI><P CLASS="kapiteloversigt-western">Polymorfi og anvendelse af
  interfaces</P>
  <LI><P CLASS="kapiteloversigt-western">Standardbibliotekets brug af
  interfaces</P>
</UL>
<P CLASS="kapiteloversigt-western">Foruds&aelig;ttes af <a href='kapitel13.jsp'>kapitel 13</a>,
H&aelig;ndelser, <a href='kapitel17.jsp'>kapitel 17</a>, Flertr&aring;det programmering, <a href='kapitel18.jsp'>kapitel
18</a>, Serialisering, <a href='kapitel19.jsp'>kapitel 19</a>, RMI og <a href='kapitel21.jsp'>kapitel 21</a>, Avancerede klasser.</P>
<P CLASS="kapiteloversigt-western">Foruds&aelig;tter <a href='kapitel5.jsp'>kapitel 5</a>, Nedarvning.<BR>I
et eksempel anvendes appletter, beskrevet i <a href='kapitel10.jsp'>kapitel 10</a>, Appletter.</P>


<P CLASS="western" STYLE="">I generel
sprogbrug er et interface (da.: snitflade) en form for gr&aelig;nseflade,
som man g&oslash;r noget gennem. F.eks. er en grafisk
brugergr&aelig;nseflade de vinduer med knapper, indtastningsfelter og
kontroller, som brugeren har til interaktion med programmet.</P>
<P CLASS="western">Vi minder om, at en klasse er definitionen af en
type objekter. Her kunne man opdele i</P>
<OL>
  <LI><P CLASS="western"><I>Gr&aelig;nsefladen</I> - hvordan
  objekterne kan bruges udefra.<BR>Dette udg&oslash;res af navnene<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>
  p&aring; metoderne, der kan ses udefra.</P>
  <LI><P CLASS="western"><I>Implementationen</I> - hvordan objekterne
  virker indeni.<BR>Dette udg&oslash;res af variabler og programkoden
  i metodekroppene.</P>
</OL>
<P CLASS="western">Et 'interface' svarer til punkt 1): En definition
af, hvordan objekter bruges udefra. Man kan sige, at et interface er
en &quot;halv&quot; klasse.</P>
<BLOCKQUOTE CLASS="definition-western">Et interface er en samling
navne p&aring; metoder (uden krop)</BLOCKQUOTE>
<P CLASS="western">Et interface kan implementeres af en klasse - det
vil sige, at klassen definerer alle interfacets metoder sammen
med programkoden, der beskriver, hvad der skal ske, n&aring;r
metoderne kaldes.</P>
<H2 CLASS="western">12.1 <a name='afsn12.1'></a>Definere et interface</SPAN></H2>
<P CLASS="western">Lad os definere et interface kaldet Tegnbar, der
beskriver noget, der kan tegnes.</P>
<PRE CLASS="kode-western">import java.awt.*;

public <B>interface Tegnbar</B>
{
  public void s&aelig;tPosition(int x, int y);

  public void tegn(Graphics g);
}</PRE><P CLASS="western">
I stedet for &quot;class&quot; erkl&aelig;res et interface med
&quot;interface&quot;. 
</P>
<P CLASS="western">Metoder i et interface har ingen krop, alle
metodeerkl&aelig;ringerne f&oslash;lges af et semikolon.</P>
<P CLASS="western">Der kan ikke oprettes objekter ud fra et
interface. Det kan opfattes som en &quot;tom skal&quot;, der skal
&quot;fyldes ud&quot; af en rigtig klasse, der implementerer
metoderne (definerer kroppene).</P>
<P CLASS="western"><IMG SRC="bog13_html_13df5e35.gif" NAME="Objekt62" ALIGN=RIGHT>Man
ser, at tegnbare objekter:</P>
<UL>
  <LI><P CLASS="western">har en metode til at s&aelig;tte positionen
  p&aring; sk&aelig;rmen</P>
  <LI><P CLASS="western">har en metode til at tegne objektet.</P>
</UL>
<P CLASS="western">I UML-notation (tegningen til h&oslash;jre) er
Tegnbar-interfacet tegnet med kursiv. Alle metoderne er
abstrakte (= ikke implementerede) og er derfor ogs&aring; tegnet
kursivt.</P>
<H2 CLASS="western">12.2 <a name='afsn12.2'></a>Implementere et interface</SPAN></H2>
<P CLASS="western">Lad os nu definere en klasse, der implementerer
Tegnbar-interfacet.</P>
<BLOCKQUOTE CLASS="definition-western">En klasse kan erkl&aelig;re,
at den <I>implementerer et interface</I> og s&aring; <U>skal</U> den
definere alle metoderne i interfacet og give dem en metodekrop</BLOCKQUOTE>
<P CLASS="western">Vi skal alts&aring; definere alle interfacets
metoder sammen med programkoden, der beskriver, hvad der skal ske,
n&aring;r metoderne kaldes. 
</P>
<PRE CLASS="kode-western" STYLE="">import java.awt.*;
public class Stjerne <B>implements Tegnbar</B>
{
  private int posX, posY;

  public void s&aelig;tPosition(int x, int y)   <I>// kr&aelig;ves af interfacet Tegnbar</I>
  {
    posX = x;
    posY = y;
  }

  public void tegn(Graphics g)            <I>// kr&aelig;ves af interfacet Tegnbar</I>
  {
    g.drawString(&quot;*&quot;,posX,posY);
  }
}</PRE><P CLASS="western">
Her har klassen Stjerne &quot;udfyldt skallen&quot; for Tegnbar ved
at skrive &quot;implements Tegnbar&quot; og definere s&aelig;tPosition()-
og tegn()-metoderne (vi har ogs&aring; variabler til at huske x og
y).</P>
<H3 CLASS="western">12.2.1 <a name='afsn12.2.1'></a>Variabler af type Tegnbar</H3>
<P CLASS="western">Man kan erkl&aelig;re variabler af en
interface-type. Disse kan referere til alle slags objekter, der
implementerer interfacet<A CLASS="sdfootnoteanc" NAME="sdfootnote2anc" HREF="#sdfootnote2sym"><SUP>2</SUP></A>.
Herunder erkl&aelig;rer vi en variabel af type Tegnbar og s&aelig;tter
den til at referere til et Stjerne-objekt.</P>
<PRE CLASS="ikke-javakode-western">    Tegnbar t;
    t = new Stjerne();       <I>// Lovligt, Stjerne implementerer Tegnbar</I></PRE><P CLASS="western">
Stjerne-objekter er ogs&aring; af type Tegnbar. Ligesom ved
nedarvning siger man, at der er relationen Stjerne er-en Tegnbar
og at t er polymorf, da den kan referere til alle slags Tegnbare
objekter. 
</P>
<P CLASS="western">Man kan ikke oprette objekter ud fra et interface
(der er en &quot;skal&quot; og intet siger om, hvordan metoderne er
implementerede - hvordan skulle objektet reagere, hvis de blev
kaldt?).</P>
<PRE CLASS="ikke-javakode-western">    t = new Tegnbar();       <I>// FEJL! Tegnbar er ikke en klasse</I></PRE><H3 CLASS="western">
12.2.2 <a name='afsn12.2.2'></a>Eksempler med interfacet Tegnbar</H3>
<P CLASS="western" STYLE="; ">
Lad os udvide (arve fra) Terning og f&aring; den til at implementere
Tegnbar-interfacet:</P>
<PRE CLASS="kode-western" STYLE="">import java.awt.*;
public class GrafiskTerning <B>extends Terning implements Tegnbar</B>
{
  int x, y;

  public void s&aelig;tPosition(int x, int y)
  {
    this.x = x;
    this.y = y;
  }

  private void ci(Graphics g, int i, int j)
  {
    g.fillOval(x+1+10*i,y+1+10*j,8,8);             <I>// Tegn fyldt cirkel</I>
  }

  public void tegn(Graphics g)
  {
    int &oslash; = v&aelig;rdi;
    g.drawRect(x,y,30,30);                         <I>// Tegn kant</I>

    if (&oslash;==1) ci(g,1,1);                           <I>// Tegn 1-6 &oslash;jne</I>
    else if (&oslash;==2) { ci(g,0,0); ci(g,2,2); }
    else if (&oslash;==3) { ci(g,0,0); ci(g,1,1); ci(g,2,2); }
    else if (&oslash;==4) { ci(g,0,0); ci(g,0,2); ci(g,2,0); ci(g,2,2); }
    else if (&oslash;==5) { ci(g,0,0); ci(g,0,2); ci(g,2,0); ci(g,2,2); ci(g,1,1); }
    else {ci(g,0,0); ci(g,0,1); ci(g,0,2); ci(g,2,0); ci(g,2,1); ci(g,2,2); }
  }
}</PRE><P CLASS="western" STYLE="">
For at g&oslash;re koden kort har tegn() en hj&aelig;lpemetode
ci(), der tegner en cirkel for et &oslash;je.</P>
<P CLASS="western">Bem&aelig;rk:</P>
<UL>
  <LI><P CLASS="western">Man kan godt have flere metoder end
  specificeret i interfacet (i dette tilf&aelig;lde ci()).</P>
  <LI><P CLASS="western">GrafiskTerning er en Tegnbar og samtidig en
  Terning. Der kan kun arves fra &eacute;n klasse, men samtidigt kan
  der godt implementeres et interface (faktisk ogs&aring; flere).</P>
</UL>

<P CLASS="western">Lad os g&oslash;re det samme med et rafleb&aelig;ger.
For variationens skyld lader vi b&aelig;geret altid have den samme
position ved at lade s&aelig;tPosition()'s krop v&aelig;re tom.</P>
<PRE CLASS="kode-western">import java.awt.*;
public class GrafiskRaflebaeger extends Raflebaeger implements Tegnbar
{
  public GrafiskRaflebaeger()
  {
    super(0);
  }

  public void s&aelig;tPosition(int x, int y)
  {
    <I>// tom metodekrop</I>  
  }

  public void tegn(Graphics g)
  {
    g.drawOval(80,20,90,54);
    g.drawLine(150,115,170,50);
    g.drawLine(100,115,80,50);
    g.drawArc(100,100,50,30,180,180);
  }
}</PRE><P CLASS="western">
Kunne vi have udeladt s&aelig;tPosition()-metoden, der alligevel ikke
g&oslash;r noget? Nej, vi har lovet at implementere begge metoder, om
det s&aring; blot er med en tom krop, idet vi skrev &quot;implements
Tegnbar&quot;.</P>

<P CLASS="western"><I>En hvilken som helst klasse kan g&oslash;res
til at v&aelig;re Tegnbar</I>. Herunder udvider vi standardklassen
Rectangle til at v&aelig;re Tegnbar:</P>
<PRE CLASS="kode-western">import java.awt.*;
public class Rektangel extends Rectangle implements Tegnbar
{
  public Rektangel(int x1, int y1, int width1, int height1)
  {
    super(y1,x1,width1,height1);
  }

  public void s&aelig;tPosition(int x1, int y1)
  {
    x = x1;
    y = y1;
  }

  public void tegn(Graphics g)
  {
    g.drawRect(x,y,width,height);
  }
}</PRE>
<H3 CLASS="western" STYLE="">12.2.3 <a name='afsn12.2.3'></a>Visning
af nogle Tegnbare objekter</H3>
<P CLASS="western">Lad os nu lave et vindue, der viser nogle tegnbare
objekter: 
</P>
<PRE CLASS="kode-western">import java.awt.*;
import java.util.*;

public class TegnbareObjekter extends Frame
{
<B>  ArrayList&lt;Tegnbar&gt; tegnbare = new ArrayList&lt;Tegnbar&gt;();</B>
  GrafiskRaflebaeger b&aelig;ger = new GrafiskRaflebaeger();

  public void s&aelig;tPositioner()
  {
    for (Tegnbar t : tegnbare) {
      int x = (int) (Math.random()*200);
      int y = (int) (Math.random()*200);
      t.s&aelig;tPosition(x,y);
    }
  }

  public TegnbareObjekter()
  {
    Stjerne <B>s = new Stjerne()</B>;
    <B>tegnbare.add(s)</B>;
    
<B>    tegnbare.add( new Rektangel(10,10,30,30) );</B>

<B>    tegnbare.add( new Rektangel(15,15,20,20) );</B>

    GrafiskTerning t;

    <B>t = new GrafiskTerning()</B>;
    b&aelig;ger.tilf&oslash;j(t);
<B>    tegnbare.add(t);</B>

<B>    t = new GrafiskTerning();</B>
    b&aelig;ger.tilf&oslash;j(t);
<B>    tegnbare.add(t);</B>

    tegnbare.add(b&aelig;ger);

    s&aelig;tPositioner();
  }

  public void paint(Graphics g)
  {
<B>    for (Tegnbar t : tegnbare)</B>
<B>    {</B>
<B>      t.tegn(g);</B>
<B>    }</B>

    s&aelig;tPositioner();

    repaint(5000); <I>// gentegn efter 5 sekunder</I>
  }
}</PRE>
<PRE CLASS="kode-western">public class VisTegnbareObjekter
{
  public static void main(String[] arg)
  {
    TegnbareObjekter vindue = new TegnbareObjekter();
    vindue.setSize(300,300);
    vindue.setVisible(true);
  }  
}</PRE><P CLASS="western">
Programmet holder styr p&aring; objekterne i tegnbare-listen. Da
stjerner, rektangler, terningerne og rafleb&aelig;geret alle er
Tegnbare, kan de behandles ens, hvad ang&aring;r tegning og
positionering.</P>
<H3 CLASS="western">12.2.4 <a name='afsn12.2.4'></a>Polymorfi</H3>
<P CLASS="western">Det er meget kraftfuldt, at man kan erkl&aelig;re
variabler af en interface-type. Disse kan referere til alle
mulige slags objekter, der implementerer interfacet. Herefter kan vi
f.eks. l&oslash;be en liste igennem og arbejde p&aring; objekterne i
den, selvom de er af vidt forskellig type.</P>
<P CLASS="western">Dette s&aring; vi i paint()-metoden i
TegnbareObjekter-klassen:</P>
<PRE CLASS="ikke-javakode-western">    for (Tegnbar t : tegnbare)
    {
      t.tegn(g);
    }</PRE><P CLASS="western">
Et interface som Tegnbar kan bruges til at etablere en f&aelig;llesn&aelig;vner
mellem vidt forskellige objekter, som derefter kan behandles
ens. Dette kaldes polymorfi (gr&aelig;sk: &quot;mange former&quot;).</P>
<P CLASS="western">F&aelig;llesn&aelig;vneren - nemlig at de alle
implementerer det samme interface - tillader os at arbejde med
objekter <SPAN STYLE="text-decoration: none"><I>uden at kende deres
pr&aelig;cise type</I><SPAN STYLE="font-style: normal">.</SPAN></SPAN>
Dette kan i mange tilf&aelig;lde v&aelig;re en fordel, n&aring;r
vi arbejder med objekter, hvor vi ikke kender (eller ikke
interesserer os for) den eksakte type.</P>
<H2 CLASS="western">12.3 <a name='afsn12.3'></a>Interfaces i standardbibliotekerne</SPAN></H2>
<P CLASS="western">Interfaces bliver brugt i vid udstr&aelig;kning i
standardbibliotekerne og mange steder benyttes polymorfi til at
g&oslash;re det muligt at lade systemet arbejde p&aring;
programm&oslash;rens egne klasser.</P>
<P CLASS="western">I det f&oslash;lgende vil vi se nogle eksempler
p&aring;, at implementationen af et interface fra
standardbiblioteket g&oslash;r, at vores klasser passer ind i
systemet p&aring; forskellig m&aring;de.</P>
<H3 CLASS="western">12.3.1 <a name='afsn12.3.1'></a>Sortering med en Comparator</H3>
<P CLASS="western">Hvis et objekt implementerer
Comparator-interfacet, skal det definere metoden:</P>
<PRE CLASS="ikke-javakode-western">  public int compare(Object obj1, Object obj2)</PRE><P CLASS="western">
Denne metode skal sammenligne obj1 og obj2 og afg&oslash;re om obj1
kommer f&oslash;r obj2 eller omvendt. For eksempel kunne vi lave en
klasse, der kan sammenligne Terning-objekter ud fra antallet af &oslash;jne,
de viser:</P>
<PRE CLASS="kode-western">import java.util.*;
public class TerningComparator <B>implements Comparator</B>
{ 
  <B>public int compare(Object obj1, Object obj2)</B> <SPAN STYLE="font-weight: medium"><I>// kr&aelig;ves af Comparator</I></SPAN>
  {
    Terning t1 = (Terning) obj1;
    Terning t2 = (Terning) obj2;
    if (t1.v&aelig;rdi == t2.v&aelig;rdi) return 0; <I>// obj1 og obj2 har samme plads</I>
    if (t1.v&aelig;rdi  &gt; t2.v&aelig;rdi) return 1; <I>// obj1 kommer efter obj2</I>
    else return -1;                     <I>// obj1 kommer f&oslash;r obj2</I>
  }
}</PRE><P CLASS="western">
En Comparator giver standardbiblioteket mulighed for at sammenligne
nogle objekter og sortere dem i forhold til hinanden. Sortering kan
bl.a. ske ved at kalde metoden Collections.sort() med en liste af
objekter og en Comparator:</P>
<PRE CLASS="kode-western">import java.util.*;
public class BenytTerningComparator
{
  public static void main(String[] arg)
  {
    ArrayList&lt;Terning&gt; liste = new ArrayList&lt;Terning&gt;();
    liste.add( new Terning());
    liste.add( new Terning());
    liste.add( new Terning());
    liste.add( new Terning());
    liste.add( new Terning());

    System.out.println(&quot;f&oslash;r sortering: &quot;+liste);
    Comparator <B>sammenligner = new TerningComparator()</B>;
    <B>Collections.sort(liste, sammenligner )</B>;
    System.out.println(&quot;efter sortering: &quot;+liste);
  }
}</PRE>
<HR>
<PRE CLASS="ikke-javakode-western">f&oslash;r sortering: [6, 3, 4, 2, 4]
efter sortering: [2, 3, 4, 4, 6]</PRE><P CLASS="western">
Metoden sort() vil l&oslash;be listen igennem og sammenligne
elementerne ved kalde compare() p&aring; Comparator-objektet for at
sortere dem i r&aelig;kkef&oslash;lge.</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><IMG SRC="bog13_html_m17317344.gif" NAME="Object27" ALIGN=MIDDLE></P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Systemkaldet
Collections.sort() sorterer en liste af elementer ved hj&aelig;lp af
en sammenligner (Comparator). </I></FONT>
</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Systemet
finder r&aelig;kkef&oslash;lgen af elementerne ved at kalde
compare() p&aring; sammenligneren<BR>til at afg&oslash;re om de
enkelte elementer kommer f&oslash;r eller efter hinanden.</I></FONT></P>
<H3 CLASS="western">12.3.2 <a name='afsn12.3.2'></a>Flere tr&aring;de med Runnable</H3>
<P CLASS="western">Hvis man vil bruge flere tr&aring;de (processer,
der k&oslash;rer samtidigt i baggrunden) i sit program, kan dette
opn&aring;s ved at implementere interfacet Runnable og definere
metoden run(). Derefter opretter man et tr&aring;d-objekt med
new Thread(objektDerImplementererRunnable). N&aring;r tr&aring;den
startes (med tr&aring;dobjekt.start()), vil det begynde en parallel
udf&oslash;relse af run()-metoden i objektDerImplementererRunnable.</P>
<P CLASS="western">Dette vil blive behandlet i <a href='kapitel17.jsp'>kapitel 17</a>, Flertr&aring;det programmering.</P>
<H3 CLASS="western">12.3.3 <a name='afsn12.3.3'></a>Lytte til musen med MouseListener</H3>
<P CLASS="western">N&aring;r man programmerer grafiske
brugergr&aelig;nseflader, kan det v&aelig;re nyttigt at kunne f&aring;
at vide, n&aring;r der er sket en h&aelig;ndelse, f.eks. at musen er
klikket et sted.</P>
<P CLASS="western">Dette sker ved, at man definerer et objekt
(lytteren), der implementerer MouseListener-interfacet. Den har
forskellige metoder, f.eks. mouseClicked(), der er beregnet p&aring;
et museklik.</P>

<P CLASS="western">Lytteren skal registreres i en grafisk komponent,
f.eks. en knap eller et vindue. Det g&oslash;res ved at kalde
komponentens addMouseListener()-metode med en reference til lytteren.
Derefter vil, hver gang brugeren klikker p&aring; komponenten,
lytterens mouseClicked() blive kaldt.</P>
<P CLASS="western">Analogt findes lyttere til tastatur,
musebev&aelig;gelser, tekstfelter, kontroller osv. I <a href='kapitel13.jsp'>kapitel 13</a> om
grafiske brugergr&aelig;nseflader og h&aelig;ndelser er disse ting
beskrevet n&aelig;rmere.</P>
<H2 CLASS="western">12.4 <a name='afsn12.4'></a>Test dig selv</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel12.jsp#afsn12.4">
  <input type='checkbox' name='vis' value='12.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='12.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">12.5 <a name='afsn12.5'></a>Resum&eacute;</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel12.jsp#afsn12.5">
  <input type='checkbox' name='vis' value='12.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='12.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">12.6 <a name='afsn12.6'></a>Opgaver</SPAN></H2>
<OL>
  <LI><P CLASS="western">Lav klassen Hus, der skal implementere
  Tegnbar. F&oslash;j den til TegnbareObjekter og pr&oslash;v, om det
  virker.</P>
  <LI><P CLASS="western">Pr&oslash;v at tilf&oslash;je et
  ikke-'Tegnbar't objekt (f.eks. en streng eller et Point-objekt) til
  tegnbare-listen. Hvad sker der s&aring;? Hvilken fejlmeddelelse
  kommer der?</P>
  <LI><P CLASS="western">Lav tre implementationer af Comparator, der
  sorterer strenge hhv. alfabetisk, omvendt alfabetisk og alfabetisk
  efter andet tegn i strengene. Lav en liste (ArrayList) med ti
  strenge og test din sortering med Collections.sort(liste,
  Comparator-objekt).</P>
  <LI><P CLASS="western">Kig p&aring; matador-spillet <a href='kapitel5.jsp#afsn5.3'>afsnit 5.3</a>. &AElig;ndr
  Felt til at v&aelig;re et interface.</P>
</OL>

<H2 CLASS="western" STYLE="">12.7 <a name='afsn12.7'></a>Avanceret</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel12.jsp#afsn12.7">
  <input type='checkbox' name='vis' value='12.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='12.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">12.7.1 <a name='afsn12.7.1'></a>Implementere flere interfaces</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel12.jsp#afsn12.7.1">
  <input type='checkbox' name='vis' value='12.7.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='12.7.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">12.7.2 <a name='afsn12.7.2'></a>At udbygge interfaces</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel12.jsp#afsn12.7.2">
  <input type='checkbox' name='vis' value='12.7.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='12.7.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">12.7.3 <a name='afsn12.7.3'></a>Multipel arv</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel12.jsp#afsn12.7.3">
  <input type='checkbox' name='vis' value='12.7.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='12.7.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">12.7.4 <a name='afsn12.7.4'></a>Variabler i et interface</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel12.jsp#afsn12.7.4">
  <input type='checkbox' name='vis' value='12.7.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='12.7.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>Egentlig
  signaturen, dvs. metodenavn og antal og type af parametre.</P>
</DIV>
<DIV ID="sdfootnote2">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote2sym" HREF="#sdfootnote2anc">2</A>Det
  vil sige alle objekter, hvis klasse implementerer interfacet.</P>
</DIV>
<DIV ID="sdfootnote3">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote3sym" HREF="#sdfootnote3anc">3</A>public=tilg&aelig;ngelig
  for alle, static=klassevariabel, final=konstant; umulig at &aelig;ndre.</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel11.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel13.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (82% af vrket).
</font>
<br>
nsker du at se de sidste 18% af dette vrk (199974 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
